% Model of a steady state isothermal plug flow reactor - Liquid phase

% Function file

% For more information, see:

% A. De Visscher 
% Lecture Notes in Chemical Engineering Kinetics and Chemical Reactor Design
% Createspace (2013) 

% (C) Alex De Visscher (2013)

% ---------------------------

function dcdW = f(W,c,cE0,cH0,cA0,k2,KE,KH,KA,Q)

dcdW = zeros(1,1);     % Allocate space for the right-hand sides of the DEs

cH = c(1);                   % Alkene concentration
cE = cE0 - (cH0 - cH);       % Hydrogen concentration (from stoichiometry)
cA = cA0 + (cH0 - cH);       % Alkane concentration (from stoichiometry)
r = k2*cE*sqrt(cH)/(1 + KE*cE + sqrt(KH*cH) + KA*cA)^2; % Reaction rate

dcdW(1) = -r/Q;            % Differential equation
